/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.upgrade;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;

public class RawRepositoryImpl
implements RawRepository {
    private Session session;
    public static final String QUERY_PREFIX = "SELECT CI.* FROM [deployit:configurationItem] AS ci WHERE";

    public RawRepositoryImpl(Session session) {
        this.session = session;
    }

    public void renameType(String string, String string2) {
        for (Node node : this.findNodesByType(Type.valueOf((String)string))) {
            try {
                node.setProperty("$configuration.item.type", string2);
            }
            catch (RepositoryException repositoryException) {
                throw new RuntimeRepositoryException(repositoryException);
            }
        }
    }

    public Node read(String string) {
        try {
            return this.session.getNode(string);
        }
        catch (RepositoryException repositoryException) {
            throw new RuntimeRepositoryException(repositoryException);
        }
    }

    public Node create(String string) {
        try {
            return this.session.getRootNode().addNode(JcrPathHelper.getIdFromAbsolutePath(string));
        }
        catch (RepositoryException repositoryException) {
            throw new RuntimeRepositoryException(repositoryException);
        }
    }

    public void delete(String string) {
        try {
            this.session.removeItem(string);
        }
        catch (RepositoryException repositoryException) {
            throw new RuntimeRepositoryException(repositoryException);
        }
    }

    public List<Node> findNodesByType(Type type) {
        ArrayList arrayList = Lists.newArrayList();
        try {
            QueryManager queryManager = this.session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery("SELECT CI.* FROM [deployit:configurationItem] AS ci WHERE ci.[$configuration.item.type] = '" + type.toString() + "'", "JCR-SQL2");
            QueryResult queryResult = query.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            while (nodeIterator.hasNext()) {
                arrayList.add(nodeIterator.nextNode());
            }
        }
        catch (RepositoryException repositoryException) {
            throw new RuntimeRepositoryException(repositoryException);
        }
        return arrayList;
    }

    public Session getSession() {
        return this.session;
    }

    public static class RuntimeRepositoryException
    extends RuntimeException {
        public RuntimeRepositoryException(Throwable throwable) {
            super(throwable);
        }
    }
}

