/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.xebialabs.deployit.exception.RuntimeIOException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileComparisonUtils {
    private static final IOFileFilter ALL_FILES_FILTER = TrueFileFilter.INSTANCE;
    private static final Logger LOG = LoggerFactory.getLogger(FileComparisonUtils.class);

    public static boolean contentEquals(File file, File file2) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        if (!file2.exists()) {
            throw new FileNotFoundException(file2.getPath());
        }
        if (file.isFile()) {
            if (file2.isFile()) {
                return FileUtils.contentEquals((File)file, (File)file2);
            }
            return false;
        }
        if (!file2.isFile()) {
            return FileComparisonUtils.directoryContentEquals(file, file2);
        }
        return false;
    }

    private static boolean directoryContentEquals(File file, File file2) {
        return Arrays.equals(FileComparisonUtils.getDirectoryChecksum(file), FileComparisonUtils.getDirectoryChecksum(file2));
    }

    private static byte[] getDirectoryChecksum(File file) {
        long l = 0L;
        if (LOG.isDebugEnabled()) {
            l = System.currentTimeMillis();
            LOG.debug(String.format("Starting to calculate directory checksum for '%s'", file, l));
        }
        MessageDigest messageDigest = FileComparisonUtils.getMd5Digest();
        Iterator iterator = FileUtils.iterateFiles((File)file, (IOFileFilter)ALL_FILES_FILTER, (IOFileFilter)ALL_FILES_FILTER);
        while (iterator.hasNext()) {
            File file2 = (File)iterator.next();
            try {
                FileComparisonUtils.updateChecksumFromContent(messageDigest, file2);
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(String.format("Unable to update message digest for file '%s'", file2), iOException);
            }
            messageDigest.update(file2.getName().getBytes());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Calculated directory checksum for '%s' in %dms", file, System.currentTimeMillis() - l));
        }
        return messageDigest.digest();
    }

    private static MessageDigest getMd5Digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Unable to create MD5 digest", noSuchAlgorithmException);
        }
    }

    private static void updateChecksumFromContent(MessageDigest messageDigest, File file) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[1024];
        do {
            if ((n = ((InputStream)fileInputStream).read(byArray)) <= 0) continue;
            messageDigest.update(byArray, 0, n);
        } while (n != -1);
        ((InputStream)fileInputStream).close();
    }
}

