/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.conversion.Base64Coder;
import com.xebialabs.deployit.exception.DeployitException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class PasswordObfuscator {
    private static final byte[] KEY_BYTES = new byte[]{-29, -22, 22, -81, -108, 95, 91, 23, 46, -26, 49, -45, -64, 112, 39, -42};
    private static final SecretKeySpec AES_KEY = new SecretKeySpec(KEY_BYTES, "AES");
    private static final Base64Coder BASE_64_CODER = new Base64Coder();

    public static boolean isEncoded(String string) {
        try {
            BASE_64_CODER.decode(string.getBytes());
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public static boolean isEncrypted(String string) {
        if (PasswordObfuscator.isEncoded(string)) {
            byte[] byArray = BASE_64_CODER.decode(string.getBytes());
            try {
                Cipher cipher = PasswordObfuscator.getCipher(2);
                cipher.doFinal(byArray);
                return true;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IllegalStateException("Could not decrypt Base64 encoded password");
            }
        }
        return false;
    }

    public static String encrypt(String string) {
        Checks.checkArgument(string != null, "The password is null", new Object[0]);
        Checks.checkArgument(!string.startsWith(BASE_64_CODER.identifier()), "The password contains the illegal sequence " + BASE_64_CODER.identifier(), new Object[0]);
        try {
            Cipher cipher = PasswordObfuscator.getCipher(1);
            return new String(BASE_64_CODER.encode(cipher.doFinal(string.getBytes())));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new DeployitException("Could not encrypt the password using AES 128");
        }
    }

    public static String ensureEncrypted(String string) {
        if (PasswordObfuscator.isEncrypted(string)) {
            return string;
        }
        return PasswordObfuscator.encrypt(string);
    }

    public static String decrypt(String string) {
        Checks.checkArgument(string != null, "The password is null", new Object[0]);
        Checks.checkArgument(string.startsWith(BASE_64_CODER.identifier()), "The password should be Base64 encoded", new Object[0]);
        try {
            Cipher cipher = PasswordObfuscator.getCipher(2);
            return new String(cipher.doFinal(BASE_64_CODER.decode(string.getBytes())));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new DeployitException("Could not decrypt the password using AES 128");
        }
    }

    public static String ensureDecrypted(String string) {
        if (PasswordObfuscator.isEncrypted(string)) {
            return PasswordObfuscator.decrypt(string);
        }
        return string;
    }

    private static Cipher getCipher(int n) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(n, AES_KEY);
        return cipher;
    }
}

