package com.xebialabs.deployit.audit;

import com.thoughtworks.xstream.XStream;

import com.xebialabs.deployit.core.xml.ConfigurationItemWriter;
import com.xebialabs.deployit.engine.xml.ConfigurationItemCollectionConverter;
import com.xebialabs.deployit.engine.xml.ConfigurationItemMarshallingStrategy;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.util.PasswordEncrypter;

public class CiFormatter {

    private final XStream xStream;

    public CiFormatter() {
        xStream = new XStream();
        xStream.registerConverter(new ConfigurationItemWriter());
        xStream.registerConverter(new ConfigurationItemCollectionConverter(xStream.getMapper()));
        xStream.setMarshallingStrategy(new ConfigurationItemMarshallingStrategy(XStream.XPATH_RELATIVE_REFERENCES));
    }

    public String format(ConfigurationItem ci) {
        return xStream.toXML(ci);
    }
}
