package com.xebialabs.deployit.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;

import static com.google.common.collect.Maps.newHashMap;
import static com.google.common.collect.Sets.newHashSet;

@SuppressWarnings("serial")
public class MapStringStringView implements Map<String, String>, Serializable {
    private Map<String, StringValue> wrapped = newHashMap();

    public MapStringStringView() {
    }

    public MapStringStringView(Map<String, StringValue> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public int size() {
        return wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return wrapped.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return wrapped.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return wrapped.containsValue(stringToStringValue(value));
    }

    @Override
    public String get(Object key) {
        return wrapped.get(key).toString();
    }

    @Override
    public String put(String key, String value) {
        StringValue put = wrapped.put(key, (StringValue) stringToStringValue(value));
        return put != null ? put.toString() : null;
    }

    public StringValue put(String key, StringValue value) {
        return wrapped.put(key, value);
    }

    @Override
    public String remove(Object key) {
        return wrapped.remove(key).toString();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        if (m instanceof MapStringStringView) {
            wrapped.putAll(((MapStringStringView) m).getWrapped());
        } else {
            wrapped.putAll(Maps.transformValues(m, new Function<String, StringValue>() {
                public StringValue apply(String input) {
                    return (StringValue) stringToStringValue(input);
                }
            }));
        }
    }

    @Override
    public void clear() {
        wrapped.clear();
    }

    @Override
    public Set<String> keySet() {
        return wrapped.keySet();
    }

    @Override
    public Collection<String> values() {
        return Collections2.transform(wrapped.values(), new Function<StringValue, String>() {
            public String apply(StringValue input) {
                return input.toString();
            }
        });
    }

    @Override
    public Set<Entry<String, String>> entrySet() {
        return newHashSet(Iterables.transform(wrapped.entrySet(), new Function<Entry<String, StringValue>, Entry<String, String>>() {
            public Entry<String, String> apply(Entry<String, StringValue> input) {
                return new HashMap.SimpleEntry<String, String>(input.getKey(), input.getValue().toString());
            }
        }));
    }

    public Map<String, StringValue> getWrapped() {
        return wrapped;
    }

    @Override
    public int hashCode() {
        return wrapped.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return wrapped.equals(obj);
    }

    protected Object stringToStringValue(Object o) {
        if (o instanceof String) {
            return new StringValue((String) o);
        }
        return o;
    }
}
