package com.xebialabs.deployit.io;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Set;

import static com.google.common.collect.Sets.newHashSet;

public class TemporaryFiles {

    private static final ThreadLocal<Set<TemporaryFile>> tempFiles = new ThreadLocal<Set<TemporaryFile>>() {
        @Override
        protected Set<TemporaryFile> initialValue() {
            return newHashSet();
        }
    };
    
    public static void register(TemporaryFile temporaryFile) {
        tempFiles.get().add(temporaryFile);
    }

    public static void clear() {
        // defensive copy so that we can delete from the collection.
        for (TemporaryFile tempFile : newHashSet(tempFiles.get())) {
            logger.debug("Trying to delete {}", tempFile);
            if (tempFile.deleteWithResponse()) {
                tempFiles.get().remove(tempFile);
            } else {
                logger.warn("Couldn't delete {}", tempFile);
            }
        }
    }

    public interface TemporaryFile {
        void delete();
        boolean deleteWithResponse();
    }

    private static final Logger logger = LoggerFactory.getLogger(TemporaryFiles.class);
}
