package com.xebialabs.deployit.jcr;

/**
 *
 */
public interface JcrConstants {

    /**
     * Username that represents the anonymous user.
     */
    String ANONYMOUS_USERNAME = "anonymous";

    /**
     * Default username for administrative user in Jackrabbit
     */
    String ADMIN_USERNAME = "admin";

    /**
     * Default password for administrative user in Jackrabbit
     */
    String ADMIN_PASSWORD = "admin";

    /**
     * JCR namespace prefix for Deployit specific types and properties
     */
    String DEPLOYIT_NAMESPACE_PREFIX = "deployit";

    /**
     * JCR namespace URI for Deployit specific types and properties
     */
    String DEPLOYIT_NAMESPACE_URI = "http://www.xebialabs.com/deployit";

    /**
     * Prefix for JCR property names that are used to store Deployit metadata.
     */
    String METADATA_PROPERTY_NAME_PREFIX = "$";

    /**
     * JCR node type name for {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem configuration items}.
     */
    String CONFIGURATION_ITEM_NODETYPE_NAME = DEPLOYIT_NAMESPACE_PREFIX + ":configurationItem";

    /**
     * JCR node type name for {@link com.xebialabs.deployit.plugin.api.udm.artifact.Artifact artifacts}.
     */
    String ARTIFACT_NODETYPE_NAME = DEPLOYIT_NAMESPACE_PREFIX + ":artifact";

    /**
     * Name of property used to store the last modification date.
     */
    String LAST_MODIFIED_DATE_PROPERTY_NAME = METADATA_PROPERTY_NAME_PREFIX + "lastModified";

    /**
     * Name of property used to store the {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem#getType() configuration item type name}
     */
    String CONFIGURATION_ITEM_TYPE_PROPERTY_NAME = METADATA_PROPERTY_NAME_PREFIX + "configuration.item.type";

    /**
     * Name of property used to store the {@link com.xebialabs.deployit.plugin.api.udm.artifact.Artifact#getFile() artifact filename}.
     */
    String FILENAME_PROPERTY_NAME = METADATA_PROPERTY_NAME_PREFIX + "filename";

    /**
     * Name of property used to store the {@link com.xebialabs.deployit.plugin.api.udm.artifact.Artifact#getFile() artifact data}.
     */
    String DATA_PROPERTY_NAME = METADATA_PROPERTY_NAME_PREFIX + "data";

    /**
     * JCR node type name for tasks.
     */
    String TASK_NODETYPE_NAME = DEPLOYIT_NAMESPACE_PREFIX + ":task";

    /**
     * Name of JCR node under which tasks are stored.
     */
    String TASKS_NODE_NAME = "tasks";

    /**
     * Full path of JCR node under which tasks are stored.
     */
    String TASKS_NODE_ID = "/" + TASKS_NODE_NAME;

    /**
     * Name of property used to store the id of a task.
     */
    String TASK_ID_PROPERTY_NAME = METADATA_PROPERTY_NAME_PREFIX + "id";

    /**
     * JCR node type name for steps.
     */
    String STEP_NODETYPE_NAME = DEPLOYIT_NAMESPACE_PREFIX + ":step";

    /**
     * Prefix used for the name of nodes that store steps.
     */
    String STEP_NODE_NAME_PREFIX = "step";

    /**
     * JCR node type name used to store the configuration
     */
    String CONFIGURATION_NODETYPE_NAME = DEPLOYIT_NAMESPACE_PREFIX + ":configuration";

    /**
     * Name of JCR node used to store the configuration
     */
    String CONFIGURATION_NODE_NAME = "$configuration";

    /**
     * Full path of JCR node used to store the configuration
     */
    String CONFIGURATION_NODE_ID = "/" + CONFIGURATION_NODE_NAME;

    /**
     * Name of JCR node used to store the version information.
     */
    String VERSIONS_NODE_NAME = CONFIGURATION_NODE_NAME + "/versions";

    /**
     * Full path of the JCR node used to store all version information under.
     */
    String VERSIONS_NODE_ID = "/" + VERSIONS_NODE_NAME;

    /**
     * Name of JCR node used to store security permissions under.
     */
    String SECURITY_NODE_NAME = CONFIGURATION_NODE_NAME + "/security";

    /**
     * Full path of the JCR node used to store security permissions under.
     */
    String SECURITY_NODE_ID = "/" + SECURITY_NODE_NAME;

    /**
     * Name of JCR node used to store security permissions under.
     */
    String ROLE_ASSIGNMENTS_NODE_NAME = CONFIGURATION_NODE_NAME + "/roleAssignments";

    /**
     * Full path of the JCR node used to store security permissions under.
     */
    String ROLE_ASSIGNMENTS_NODE_ID = "/" + ROLE_ASSIGNMENTS_NODE_NAME;

    /**
     * Name of JCR node used to store security permissions under.
     */
    String ROLES_NODE_NAME = CONFIGURATION_NODE_NAME + "/roles";

    /**
     * Full path of the JCR node used to store security permissions under.
     */
    String ROLES_NODE_ID = "/" + ROLES_NODE_NAME;

    /**
     * Indicates global permissions when querying security.
     */
    String GLOBAL_SECURITY_ALIAS = "global";

    /**
     * Name of the property used to store the optimistic locking token.
     */
    String TOKEN_PROPERTY_NAME = "$token";
}
