package com.xebialabs.deployit.jcr.grouping;

import com.xebialabs.deployit.task.archive.ArchivedTask;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

public class Duration implements Function<List<Long>> {

    private final String name;

    public Duration(String name) {
        this.name = name;
    }

    @SuppressWarnings("unchecked")
    @Override
    public List<Long> invoke(Object previousValue, ArchivedTask task) {
        List<Long> durationList = null;
        if (previousValue != null) {
            durationList = (List<Long>) previousValue;
        } else {
            durationList = newArrayList();
        }
        long millis = task.getCompletionDate().getMillis() - task.getStartDate().getMillis();
        durationList.add(millis);
        return durationList;
    }

    @Override
    public String getName() {
        return name;
    }
}
