package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.util.Tuple;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.deployit.util.Tuple.of;

public class ChangeSet {

    private List<ConfigurationItem> createCis = newArrayList();
    private List<ConfigurationItem> updateCis = newArrayList();
    private List<String> deleteCiIds = newArrayList();
    private List<Tuple<ConfigurationItem, String>> moveCis = newArrayList();
    private List<Tuple<String, String>> renameCis = newArrayList();
    private List<ConfigurationItem> createOrUpdateCis = newArrayList();

    public void create(ConfigurationItem ci) {
        this.createCis.add(ci);
    }

    public void update(ConfigurationItem ci) {
        this.updateCis.add(ci);
    }

    public void delete(ConfigurationItem ci) {
        this.deleteCiIds.add(ci.getId());
    }

    public void move(ConfigurationItem ci, String newId) {
        this.moveCis.add(of(ci, newId));
    }

    public void rename(ConfigurationItem ci, String newName) {
        this.renameCis.add(of(ci.getId(), newName));
    }

    public List<ConfigurationItem> getCreateCis() {
        return createCis;
    }

    public void setCreateCis(List<ConfigurationItem> createCis) {
        this.createCis = createCis;
    }

    public List<ConfigurationItem> getUpdateCis() {
        return updateCis;
    }

    public void setUpdateCis(List<ConfigurationItem> updateCis) {
        this.updateCis = updateCis;
    }

    public List<String> getDeleteCiIds() {
        return deleteCiIds;
    }

    public void setDeleteCiIds(List<String> deleteCiIds) {
        this.deleteCiIds = deleteCiIds;
    }

    public <T extends ConfigurationItem> void addMoveCi(T entity, String newId) {
        this.moveCis.add(Tuple.<ConfigurationItem, String>of(entity, newId));
    }

    public List<Tuple<ConfigurationItem, String>> getMoveCis() {
        return moveCis;
    }

    public <T extends ConfigurationItem> void addRenameCi(String entity, String newName) {
        renameCis.add(of(entity, newName));
    }

    public List<Tuple<String, String>> getRenameCis() {
        return renameCis;
    }

    public <T extends ConfigurationItem> void createOrUpdate(List<T> entities) {
        this.createOrUpdateCis.addAll(entities);
    }

    public <T extends ConfigurationItem> void createOrUpdate(T entity) {
        this.createOrUpdateCis.add(entity);
    }

    public List<ConfigurationItem> getCreateOrUpdateCis() {
        return createOrUpdateCis;
    }
}
