package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.core.*;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.util.List;
import java.util.Map;
import java.util.Set;

import static com.google.common.collect.Maps.newHashMap;
import static com.google.common.collect.Sets.newHashSet;

public class ConfigurationItemCloner {

    @SuppressWarnings("unchecked")
    public static <T extends ConfigurationItem> T cloneShallow(T configurationItem) {
        Descriptor descriptor = configurationItem.getType().getDescriptor();
        T newInstance = descriptor.<T>newInstance();
        newInstance.setId(configurationItem.getId());
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            switch (pd.getKind()) {
                case BOOLEAN:
                case INTEGER:
                case STRING:
                case ENUM:
                    pd.set(newInstance, pd.get(configurationItem));
                    break;
                case CI:
                    pd.set(newInstance, pd.get(configurationItem));
                    break;
                case SET_OF_STRING:
                    Set<String> o = (Set<String>) pd.get(configurationItem);
                    if (o instanceof SetOfStringView) {
                        Set<StringValue> wrapped = ((SetOfStringView) o).getWrapped();
                        pd.set(newInstance, new SetOfStringView(newHashSet(wrapped)));
                    } else {
                        pd.set(newInstance, newHashSet(o));
                    }
                    break;
                case SET_OF_CI:
                    pd.set(newInstance, newHashSet((Set<ConfigurationItem>) pd.get(configurationItem)));
                    break;
                case LIST_OF_STRING:
                    List<String> l = (List<String>) pd.get(configurationItem);
                    if (l instanceof ListOfStringView) {
                        List<StringValue> wrapped = ((ListOfStringView) l).getWrapped();
                        pd.set(newInstance, new SetOfStringView(newHashSet(wrapped)));
                    } else {
                        pd.set(newInstance, newHashSet(l));
                    }
                    break;
                case LIST_OF_CI:
                    pd.set(newInstance, newHashSet((List<ConfigurationItem>) pd.get(configurationItem)));
                    break;
                case MAP_STRING_STRING:
                    Map<String, String> m = (Map<String, String>) pd.get(configurationItem);
                    if (m instanceof MapStringStringView) {
                        Map<String, StringValue> wrapped = ((MapStringStringView) m).getWrapped();
                        pd.set(newInstance, new MapStringStringView(newHashMap(wrapped)));
                    } else {
                        pd.set(newInstance, newHashMap(m));
                    }
                    break;
            }
        }
        return newInstance;
    }
}
