package com.xebialabs.deployit.repository;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.util.List;
import java.util.Map;

import static com.google.common.collect.Lists.newArrayList;

/**
 * FIXME: Can we get rid of this class? Or move it to a test.support package?
 */
public class InMemoryRepositoryService implements RepositoryService {
    private Map<String, ConfigurationItem> store = Maps.newHashMap();

    @Override
    public boolean exists(final String id) {
        return store.containsKey(id);
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T extends ConfigurationItem> T read(final String id) {
        return (T) store.get(id);
    }

    @Override
    public <T extends ConfigurationItem> T read(final String id, WorkDir workDir) {
        return this.<T>read(id);
    }

    @Override
    public <T extends ConfigurationItem> void create(final T... entities) {
        checkThatEntitiesDoNotExist(entities);
        storeEntities(entities);
    }

    private void checkThatEntitiesDoNotExist(final ConfigurationItem[] entities) {
        for (ConfigurationItem entity : entities) {
            if (store.containsKey(entity.getId())) {
                throw new IllegalStateException("Entity " + entity.getId() + " already exists and cannot be created twice.");
            }
        }
    }

    private void storeEntities(final ConfigurationItem[] entities) {
        for (ConfigurationItem entity : entities) {
            store.put(entity.getId(), entity);
        }
    }

    @Override
    public <T extends ConfigurationItem> void update(final T... entities) {
        for (T entity: entities) {
            if (!store.containsKey(entity.getId())) {
                throw new IllegalStateException("Cannot update nonexisting");
            }
        }

        for (T entity: entities) {
            store.put(entity.getId(), entity);
        }

    }

    @Override
    public <T extends ConfigurationItem> void move(T entity, String newId) {
        store.remove(entity.getId());
        entity.setId(newId);
        store.put(newId, entity);
    }

    @Override
    public <T extends ConfigurationItem> void createOrUpdate(T... entities) {
        for (T entity: entities) {
            store.put(entity.getId(), entity);
        }
    }

    @Override
    public void rename(String id, String newName) {
        ConfigurationItem remove = store.remove(id);
        remove.setId(id.substring(0, id.lastIndexOf('/') + 1) + newName);
        store.put(remove.getId(), remove);
    }

    @Override
    public void delete(final String... ids) {
        for(String id: ids) {
            store.remove(id);
        }
    }

    @Override
    public void execute(ChangeSet batchUpdate) {
        if (!batchUpdate.getCreateCis().isEmpty()) {
            create(batchUpdate.getCreateCis().toArray(new ConfigurationItem[batchUpdate.getCreateCis().size()]));
        }

        if (!batchUpdate.getUpdateCis().isEmpty()) {
            update(batchUpdate.getUpdateCis().toArray(new ConfigurationItem[batchUpdate.getUpdateCis().size()]));
        }

        if (!batchUpdate.getDeleteCiIds().isEmpty()) {
            delete(batchUpdate.getDeleteCiIds().toArray(new String[batchUpdate.getDeleteCiIds().size()]));
        }
    }

    @Override
    public List<ConfigurationItemData> list(final SearchParameters criteria) {
        List<ConfigurationItemData> ids = newArrayList();
        if (criteria.type != null) {
            for (ConfigurationItem configurationItem : store.values()) {
                if (configurationItem.getType().equals(criteria.type)) {
                    ids.add(new ConfigurationItemData(configurationItem.getId(), configurationItem.getType()));
                }
            }
            return ids;
        }
        throw new UnsupportedOperationException("Ask Jeroen");
    }

    @Override
    public <T extends ConfigurationItem> List<T> listEntities(SearchParameters parameters) {
        throw new UnsupportedOperationException("Ask Robert and Vincent");
    }

    @Override
    public void checkReferentialIntegrity(ChangeSet batchUpdate) throws ItemInUseException {
        //do nothing
    }
    
    @Override
    public <T extends ConfigurationItem> List<T> getVersionHistory(String id) {
        throw new UnsupportedOperationException("Not implemented for " + this.getClass());
    }

    @Override
    public <T extends ConfigurationItem> T read(final String id, final boolean useCache) {
        return this.<T>read(id);
    }

    @Override
    public <T extends ConfigurationItem> T read(final String id, final WorkDir workDir, final boolean useCache) {
        return this.<T>read(id);
    }

}
