package com.xebialabs.deployit.repository;

import java.util.List;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;

import com.xebialabs.deployit.engine.spi.command.*;
import com.xebialabs.deployit.engine.spi.command.util.Update;
import com.xebialabs.deployit.engine.spi.event.DeployitEventListener;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import nl.javadude.t2bus.Subscribe;

@DeployitEventListener
public class RepositoryEventListener {

    @Subscribe
    public void receiveCreate(CreateCiCommand command) {
        RepositoryServiceHolder.getRepositoryService().create(command.getCi());
    }

    @Subscribe
    public void receiveCreate(CreateCisCommand command) {
        final List<ConfigurationItem> cis = command.getCis();
        RepositoryServiceHolder.getRepositoryService().create(cis.toArray(new ConfigurationItem[cis.size()]));
    }

    @Subscribe
    public void receiveUpdate(UpdateCiCommand command) {
        RepositoryServiceHolder.getRepositoryService().update(command.getUpdate().getNewCi());
    }

    @Subscribe
    public void receiveUpdate(UpdateCisCommand command) {
        List<Update> updates = command.getUpdates();
        FluentIterable<ConfigurationItem> transform = FluentIterable.from(updates).transform(new Function<Update, ConfigurationItem>() {
            @Override
            public ConfigurationItem apply(final Update input) {
                return input.getNewCi();
            }
        });
        RepositoryServiceHolder.getRepositoryService().update(transform.toArray(ConfigurationItem.class));
    }
    @Subscribe
    public void receiveDelete(DeleteCiCommand command) {
        RepositoryServiceHolder.getRepositoryService().delete(command.getCi().getId());
    }

    @Subscribe
    public void receiveDelete(DeleteCisCommand command) {
        List<ConfigurationItem> updates = command.getCis();
        FluentIterable<String> transform = FluentIterable.from(updates).transform(new Function<ConfigurationItem, String>() {
            public String apply(final ConfigurationItem input) {
                return input.getId();
            }
        });
        RepositoryServiceHolder.getRepositoryService().delete(transform.toArray(String.class));
    }
}
