package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.plugin.api.deployment.planning.ReadOnlyRepository;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class RepositoryViewer implements ReadOnlyRepository {

    private RepositoryService repositoryService;

    @Autowired
    public RepositoryViewer(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
    
    @Override
    public <T extends ConfigurationItem> T read(String id) {
        return repositoryService.<T>read(id);
    }

    @Override
    public <T extends ConfigurationItem> List<T> search(Type type) {
        return repositoryService.listEntities(new SearchParameters().setType(type));
    }

    @Override
    public <T extends ConfigurationItem> List<T> search(Type type, String parent) {
        return repositoryService.listEntities(new SearchParameters().setType(type).setParent(parent));
    }
}
