package com.xebialabs.deployit.repository;

import java.util.Calendar;
import java.util.Map;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;

/**
 */
public class SearchParameters {

    Type type;
    String parent;
    String name;
    Map<String, String> properties = Maps.newHashMap();
    long page = 0;
    long resultsPerPage = 0;
    Calendar before;

    public SearchParameters setType(Type type) {
        this.type = type;
        return this;
    }

    public SearchParameters addProperty(String key, String value) {
        properties.put(key, value);
        return this;
    }

    public SearchParameters setParent(String parent) {
        this.parent = parent;
        return this;
    }

    public SearchParameters setName(final String name) {
        this.name = name;
        return this;
    }

    public SearchParameters setPage(long page) {
        this.page = page;
        return this;
    }

    public SearchParameters setResultsPerPage(long nrOfResults) {
        this.resultsPerPage = nrOfResults;
        return this;
    }

    public void setBefore(Calendar before) {
        this.before = before;
    }
}
