package com.xebialabs.deployit.repository;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

import static com.google.common.base.Preconditions.checkState;

@SuppressWarnings("serial")
public class WorkDir implements Serializable {

    private AtomicInteger uniqueDir = new AtomicInteger(0);
    private final LocalFile workDir;

    public WorkDir(LocalFile workDir) {
        this.workDir = workDir;
    }

    public LocalFile newFile(String filename) {
        checkState(workDir.exists(), "Cannot create a new file when workDir [%s] does not exist.", workDir);
        return newUniqueFile(filename);
    }

    private LocalFile newUniqueFile(String filename) {
        OverthereFile file = workDir.getFile("artifact-" + uniqueDir.getAndIncrement());
        checkState(!file.exists(), "The unique artifact dir [%s] should not exist yet", file.getPath());
        file.mkdir();
        return (LocalFile) file.getFile(filename);
    }

    public String getPath() {
        return workDir.getPath();
    }

    public void delete() {
        logger.debug("Deleting workDir {}", this);
        if (workDir.exists()) {
            this.workDir.deleteRecursively();
            checkState(!workDir.exists(), "Workdirectory %s should have been deleted.", this);
        } else {
            logger.warn("Workdirectory {} already deleted.", this);
        }
    }

    @Override
    public String toString() {
        return "WorkDir[" + getPath() + "]";
    }

    private static final Logger logger = LoggerFactory.getLogger(WorkDir.class);
}
