package com.xebialabs.deployit.security;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

public class Role {
    private Integer id;
    private String name;
    private List<String> principalsAssigned = newArrayList();

    public Role(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Role(String name) {
        this(null, name);
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getPrincipalsAssigned() {
        return principalsAssigned;
    }

    @Override
    public String toString() {
        return name;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Role) {
            Role o = (Role) obj;
            return (id == null && o.id == null) ? name.equals(o.name) : (id != null && id.equals(o.id));
        }
        return false;
    }
}
