package com.xebialabs.deployit.security.permission;

import com.google.common.base.Strings;

public class PermissionHandler {

    private Permission permission;

    public PermissionHandler(Permission permission) {
        this.permission = permission;
    }

    public enum Level {
        GLOBAL,
        CI,
        BOTH
    }

    public Permission getPermission() {
        return this.permission;
    }

    public boolean hasPermission(String onConfigurationItem) {
        if (Strings.nullToEmpty(onConfigurationItem).trim().isEmpty()) {
            return PermissionHelper.hasPermission(getPermission());
        }
        return PermissionHelper.hasPermission(getPermission()) || PermissionHelper.hasPermission(getPermission(), onConfigurationItem);
    }
}
