package com.xebialabs.deployit.security.permission;

import java.util.ArrayList;

import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.SecurityServiceLocator;

import static com.google.common.collect.Lists.newArrayList;

public class ReadPermissionHandler extends PermissionHandler {

    public ReadPermissionHandler() {
        super(Permission.READ);
    }

    @Override
    public boolean hasPermission(String onConfigurationItem) {
        PermissionEnforcer permissionEnforcer = SecurityServiceLocator.getPermissionEnforcer();
        ArrayList<Permission> ciPermissions = newArrayList(Permission.READ,
                Permission.DEPLOY_INITIAL, Permission.DEPLOY_UPGRADE, Permission.UNDEPLOY,
                Permission.IMPORT_INITIAL, Permission.IMPORT_UPGRADE, Permission.IMPORT_REMOVE);
        return permissionEnforcer.hasLoggedInUserPermission(ciPermissions, onConfigurationItem);
    }
}
