package com.xebialabs.deployit.service.controltask;

import com.xebialabs.deployit.deployment.planner.StepAdapter;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;

import org.springframework.stereotype.Component;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.deployit.checks.Checks.checkArgument;
import static java.lang.String.format;

@Component
public class ControlTaskService {

    public TaskSpecification prepareControlTask(ConfigurationItem ci, String controlTaskName, WorkDir workDir) {
        MethodDescriptor method = DescriptorRegistry.getDescriptor(ci.getType()).getControlTask(controlTaskName);
        checkArgument(method != null, "ConfigurationItem %s of type %s does not have a control task named %s.", ci.getId(), ci.getType(), controlTaskName);

        List<?> steps = method.invoke(ci);
        List<Step> flowSteps = newArrayList();
        for (Object step : steps) {
            flowSteps.add(StepAdapter.wrapIfNeeded(step));
        }

        TaskSpecification taskSpecification = new TaskSpecification(format("Control task [%s] for %s", controlTaskName, ci.getId()), Permissions.getAuthentication().getName(), flowSteps);
        taskSpecification.getListeners().add(new WorkdirCleanerTrigger(workDir));
        taskSpecification.getMetadata().put("taskType", TaskType.CONTROL.name());
        return taskSpecification;
    }
}