package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.ChangeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSetBuilder {

    public static ChangeSet determineChanges(DeltaSpecification specification) {
        ChangeSet changeSet = new ChangeSet();
        addDeployedApplication(changeSet, specification);
        for (Delta delta : specification.getDeltas()) {
            switch (delta.getOperation()) {
                case CREATE:
                    changeSet.create(delta.getDeployed());
                    specification.getDeployedApplication().addDeployed(delta.getDeployed());
                    logger.debug("The CI {} will be {} in the repository", delta.getDeployed().getId(), delta.getOperation());
                    break;
                case MODIFY:
                case NOOP:
                    changeSet.update(delta.getDeployed());
                    specification.getDeployedApplication().addDeployed(delta.getDeployed());
                    logger.debug("The CI {} will be {} in the repository", delta.getDeployed().getId(), delta.getOperation());
                    break;
                case DESTROY:
                    changeSet.delete(delta.getPrevious());
                    logger.debug("The CI {} will be {} in the repository", delta.getPrevious().getId(), delta.getOperation());
                    break;
            }
        }

        logger.debug("DeployedApplication {} will contain the following deployeds {}", specification.getDeployedApplication(), specification.getDeployedApplication().getDeployeds());

        return changeSet;
    }

    private static void addDeployedApplication(ChangeSet changeSet, DeltaSpecification specification) {
        DeployedApplication deployedApplication = specification.getDeployedApplication();
        switch (specification.getOperation()) {
            case CREATE:
                changeSet.create(deployedApplication);
                break;
            case MODIFY:
                changeSet.update(deployedApplication);
                break;
            case DESTROY:
                changeSet.delete(deployedApplication);
                break;
            case NOOP:
                break;
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(ChangeSetBuilder.class);

}
