package com.xebialabs.deployit.service.deployment;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;

import static com.xebialabs.deployit.engine.spi.execution.Transitions.checkTransition;
import static com.xebialabs.deployit.service.deployment.ChangeSetBuilder.determineChanges;

public class RepositoryUpdateTrigger implements ExecutionStateListener {
    private DeltaSpecification specification;

    public RepositoryUpdateTrigger(DeltaSpecification specification) {
        this.specification = specification;
    }

    @Override
    public void stepStateChanged(StepExecutionStateEvent event) {
    }

    @Override
    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (checkTransition(event, TaskExecutionState.QUEUED, TaskExecutionState.EXECUTING)) {
            checkReferentialIntegrity(determineChanges(specification));
        } else if (checkTransition(event, TaskExecutionState.EXECUTING, TaskExecutionState.EXECUTED)) {
            persist(determineChanges(specification));
        }
    }

    private void persist(ChangeSet changeSet) {
        RepositoryServiceHolder.getRepositoryService().execute(changeSet);
    }

    private void checkReferentialIntegrity(ChangeSet changeSet) {
        RepositoryServiceHolder.getRepositoryService().checkReferentialIntegrity(changeSet);
    }

    private static final Logger logger = LoggerFactory.getLogger(RepositoryUpdateTrigger.class);
}
