package com.xebialabs.deployit.service.discovery;

import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskInspectionContext;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.inspection.Inspector;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;
import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;

@SuppressWarnings("serial")
public class DiscoveryContext implements TaskInspectionContext {
    private Task task;
    private Map<String, ConfigurationItem> discovered = newHashMap();
    private Map<String, ConfigurationItem> inspected = newHashMap();

    @Override
    public void registerTask(Task task) {
        this.task = task;
        for (ConfigurationItem configurationItem : newArrayList(discovered.values())) {
            Inspector.inspect(configurationItem, this);
        }
    }

    @Override
    public void discovered(ConfigurationItem item) {
        checkArgument(item.getId() != null, "Discovered configuration item must have an id set.");
        discovered.put(item.getId(), item);
    }

    @Override
    public Map<String, ConfigurationItem> getDiscovered() {
        return discovered;
    }

    @Override
    public void inspected(ConfigurationItem item) {
        if(discovered.remove(item.getId()) == null) {
            logger.warn("{} has been inspected without being discovered", item);
        }
        this.inspected.put(item.getId(), item);
    }

    @Override
    public Map<String, ConfigurationItem> getInspected() {
        return inspected;
    }

    @Override
    public void addStep(Step step) {
        checkState(task != null, "Task is not set.");
        task.getTaskSteps().add(new TaskStep(step));
    }

    private static final Logger logger = LoggerFactory.getLogger(DiscoveryContext.class);
}
