package com.xebialabs.deployit.service.discovery;

import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.util.HashMap;
import java.util.List;

import static com.google.common.collect.Maps.newHashMap;

class DiscoveryResults {
    private static final HashMap<String, DiscoveryResult> results = newHashMap();

    static void register(TaskState task, List<ConfigurationItem> result) {
        results.put(task.getId(), new DiscoveryResult(task.getId(), task.getOwner(), result));
    }

    static DiscoveryResult retrieve(String taskId) {
        return results.remove(taskId);
    }
}
