package com.xebialabs.deployit.service.discovery;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import org.springframework.stereotype.Component;

@Component
public class DiscoveryService {

    public TaskSpecification prepareDiscovery(ConfigurationItem ci, WorkDir workDir) {
        DiscoveryContext inspectionContext = new DiscoveryContext();
        inspectionContext.discovered(ci);
        TaskSpecification spec = new TaskSpecification("Inspection of " + ci.getId(), Permissions.getAuthentication().getName(), Lists.<Step>newArrayList(), inspectionContext);
        spec.getListeners().add(new WorkdirCleanerTrigger(workDir));
        spec.getListeners().add(new DiscoveryTrigger(inspectionContext));
        spec.getMetadata().put("taskType", TaskType.INSPECTION.name());
        return spec;
    }

    public DiscoveryResult getDiscoveryResults(String taskId) {
        DiscoveryResult retrieve = DiscoveryResults.retrieve(taskId);
        Preconditions.checkArgument(retrieve != null, "Could not find any results associated with the id [%s]", taskId);
        return retrieve;
    }
}
