package com.xebialabs.deployit.service.discovery;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.inspection.Inspector;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.deployit.engine.api.execution.StepExecutionState.DONE;
import static com.xebialabs.deployit.engine.api.execution.StepExecutionState.EXECUTING;
import static com.xebialabs.deployit.engine.spi.execution.Transitions.checkTransition;

public class DiscoveryTrigger implements ExecutionStateListener {
    private DiscoveryContext context;

    public DiscoveryTrigger(DiscoveryContext context) {
        this.context = context;
    }

    @Override
    public void stepStateChanged(StepExecutionStateEvent event) {
        if (checkTransition(event, EXECUTING, DONE)) {
            logger.debug("Checking whether we need to add more steps for recently discovered items.");
            addStepsForDiscoveredItems();
        }
    }

    private void addStepsForDiscoveredItems() {
        // Need to wrap in new list to prevent iteration exception due to call to inspected.
        for (ConfigurationItem ci : newArrayList(context.getDiscovered().values())) {
            Inspector.inspect(ci, context);
        }
    }

    @Override
    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (checkTransition(event, TaskExecutionState.EXECUTING, TaskExecutionState.EXECUTED)) {
            logger.info("Registering inspection results of task [{}]", event.task().getId());
            DiscoveryResults.register(event.task(), newArrayList(context.getInspected().values()));
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(DiscoveryTrigger.class);
}
