package com.xebialabs.deployit.service.gc;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;

import java.util.concurrent.atomic.AtomicBoolean;

@SuppressWarnings("serial")
public class GarbageCollectionSemaphore implements ExecutionStateListener {

    private static final AtomicBoolean progress = new AtomicBoolean(false);


    @Override
    public void stepStateChanged(StepExecutionStateEvent event) {
    }

    @Override
    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (event.currentState() == TaskExecutionState.EXECUTING) {
            progress.set(true);
        } else if (event.currentState() == TaskExecutionState.STOPPED || event.currentState() == TaskExecutionState.DONE) {
            progress.set(false);
        }
    }

    public static boolean isInProgress() {
        return progress.get();
    }
}
