package com.xebialabs.deployit.service.gc;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.tasker.Engine;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.security.Permissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GarbageCollectionServiceImpl implements GarbageCollectionService {

    private Engine engine;

    @Autowired
    public GarbageCollectionServiceImpl(Engine engine) {
        this.engine = engine;
    }

    @Override
    public void runGarbageCollector() {
        if (GarbageCollectionSemaphore.isInProgress()) {
            logger.warn("Not starting new garbage collector since garbage collection already in progress");
            return;
        }

        GarbageCollectionStep garbageCollectionStep = new GarbageCollectionStep();
        TaskSpecification spec = new TaskSpecification("Garbage collection", Permissions.getAuthentication().getName(), Lists.<Step>newArrayList(garbageCollectionStep));
        spec.getListeners().add(new GarbageCollectionSemaphore());

        String id = engine.register(spec);
        engine.execute(id);
    }

    private static final Logger logger = LoggerFactory.getLogger(GarbageCollectionServiceImpl.class);
}
