package com.xebialabs.deployit.service.gc;

import java.lang.reflect.Field;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.api.management.DataStoreGarbageCollector;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.jcr.JcrConstants;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;

@SuppressWarnings({"serial"})
public class GarbageCollectionStep implements Step {

    public GarbageCollectionStep() {
    }

    @Override
    public int getOrder() {
        return 50;
    }

    @Override
    public String getDescription() {
        return "Running garbage collection on the repository";
    }

    public StepExitCode execute(ExecutionContext ctx)
            throws Exception {
        logger.info("Running garbage collector to compact the DataStore");

        try {
            JcrTemplate jcrTemplate = JcrTemplateHolder.get();
            Field repositoryField = JcrTemplate.class.getDeclaredField("repository");
            repositoryField.setAccessible(true);
            Repository repository = (Repository) repositoryField.get(jcrTemplate);
            Session garbageCollectionSession = repository.login(new SimpleCredentials(JcrConstants.ANONYMOUS_USERNAME, "".toCharArray()));
            try {
                // Note: casting the repository here to RepositoryImpl to get at the garbage collector.
                // The repository is created in the JackrabbitRepositoryFactoryBean as a RepositoryImpl instance.
                DataStoreGarbageCollector gc = ((RepositoryImpl) repository).createDataStoreGarbageCollector();
                try {
                    gc.mark();
                    gc.sweep();
                } finally {
                    gc.close();
                }

            } finally {
                garbageCollectionSession.logout();
            }

            logger.info("Garbage collector completed");
        } catch (RepositoryException exc) {
            logger.error("Cannot run the gargage collector", exc);
        }

        // Task is non-interactive, so always returning success.
        return StepExitCode.SUCCESS;
    }

    private static final Logger logger = LoggerFactory.getLogger(GarbageCollectionStep.class);
}
