package com.xebialabs.deployit.service.importer.reader;

import java.util.Collection;
import java.util.Map;
import java.util.jar.Attributes;

import static com.google.common.collect.Maps.newHashMap;
import static com.google.common.collect.Sets.newHashSet;

public class ManifestEntry {

    private final String name;
    private final Attributes attributes;

    public ManifestEntry(String name, Attributes attributes) {
        this.name = name.trim();
        this.attributes = attributes;
    }

    public String getName() {
        return name;
    }

    public String getValue(String name) {
        return attributes.getValue(name);
    }
    
    public Map<String, String> getMap(String name) {
        String keyStart = ("CI-" + name + "-").toLowerCase();
        Map<String, String> map = newHashMap();
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String s = entry.getKey().toString();
            if (s.toLowerCase().startsWith(keyStart)) {
                String mapKey = s.substring(keyStart.length());
                String mapValue = (String) entry.getValue();
                map.put(mapKey, mapValue);
            }
        }
        return map;
    }
    
    public Collection<String> getStrings(String name) {
        String oldStyle = ("CI-" + name + "-EntryValue").toLowerCase();
        String key = ("CI-" + name).toLowerCase();
        final Collection<String> strings = newHashSet();
        for (Map.Entry<Object, Object> attribute : attributes.entrySet()) {
            String entryKey = attribute.getKey().toString().toLowerCase().trim();
            if (entryKey.startsWith(oldStyle) || entryKey.equals(key)) {
                strings.add(attribute.getValue().toString());
            }
        }

        return strings;
    }

}
