package com.xebialabs.deployit.service.replacement;

import com.xebialabs.deployit.engine.replacer.PlaceholderScanner;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;

import static com.google.common.collect.Sets.newHashSet;
import static com.xebialabs.deployit.service.replacement.MustachePlaceholders.newMustacheCompiler;

public class MustachePlaceholderScanner implements PlaceholderScanner {

    Set<String> keys = newHashSet();

    public Set<String> scan(String in) {
        newMustacheCompiler().compile(in).execute(new ScannerMap(), new DiscardingWriter());
        return keys;
    }

    public Set<String> scan(Reader in) {
        newMustacheCompiler().compile(in).execute(new ScannerMap(), new DiscardingWriter());
        return keys;
    }

    public static boolean hasPlaceholders(String value) {
        return !new MustachePlaceholderScanner().scan(value).isEmpty();
    }

    @SuppressWarnings("serial")
    private class ScannerMap extends HashMap<String, Object> {
        @Override
        public Object get(Object o) {
            keys.add((String) o);
            return "";
        }
    }

    private static class DiscardingWriter extends Writer {
        @Override
        public void write(char[] chars, int i, int i1) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

}
