package com.xebialabs.deployit.service.replacement;

import java.util.Map;

import com.xebialabs.deployit.core.EncryptedStringValue;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.util.Tuple;

import static java.lang.String.format;

public class PlaceholderExpander {
    public static MapStringStringView expand(MapStringStringView entries) {
        MapStringStringView expanded = new MapStringStringView();
        expanded.putAll(entries);
        doExpand(expanded);
        return expanded;
    }

    private static void doExpand(MapStringStringView expanded) {
        for (Map.Entry<String, StringValue> entry : expanded.getWrapped().entrySet()) {
            StringValue value = entry.getValue();
            value = doExpand(expanded, entry, value);
            expanded.put(entry.getKey(), value);
        }
    }

    private static StringValue doExpand(MapStringStringView expanded, Map.Entry<String, StringValue> entry, StringValue value) {
        Tuple<Integer, Integer> marker = findMarker(value);
        if (marker.getA() != -1) {
            StringValue expandedValue = expand(value, entry, marker, expanded);
            String s = value.toString().substring(0, marker.getA()) + expandedValue + value.toString().substring(marker.getB() + 2);
            if (value instanceof EncryptedStringValue || expandedValue instanceof EncryptedStringValue) {
                value = doExpand(expanded, entry, new EncryptedStringValue(s));
            } else {
                value = doExpand(expanded, entry, new StringValue(s));
            }
        }
        return value;
    }

    private static StringValue expand(StringValue value, Map.Entry<String, StringValue> entry, Tuple<Integer, Integer> marker, MapStringStringView expanded) {
        String key = value.toString().substring(marker.getA() + 2, marker.getB());
        if (key.equals(entry.getKey())) {
            throw new PlaceHolderStateException(format("Cannot expand placeholder %s because it contains a cyclic reference. Key %s refers to %s.", value, entry.getKey(), entry.getValue()));
        }
        if (!expanded.containsKey(key)) {
            throw new PlaceHolderStateException(format("Cannot expand placeholder %s because it references an unknown key %s", value, key));
        }
        return expanded.getWrapped().get(key);
    }

    private static Tuple<Integer, Integer> findMarker(StringValue value) {
        int beginMarker = value.toString().indexOf("{{");
        if (beginMarker > -1) {
            int endMarker = value.toString().indexOf("}}", beginMarker);
            if (endMarker == -1) {
                throw new PlaceHolderStateException("Couldn't find placeholder end marker in [" + value + "]");
            }
            return Tuple.of(beginMarker, endMarker);
        }
        return Tuple.of(-1, -1);
    }
}
