package com.xebialabs.deployit.service.replacement;

import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;

@SuppressWarnings("serial")
@HttpResponseCodeResult(statusCode = 400)
public class PlaceholderScanningFailedException extends DeployitException {

    private PlaceholderScanningFailedException(Exception e, String msg, Object... params) {
        super(e, msg, params);
    }

    public static void throwException(String id, RuntimeException re) throws PlaceholderScanningFailedException {
        throw new PlaceholderScanningFailedException(re, "Unable to scan placeholders in [%s]. " +
                "See: http://docs.xebialabs.com/faq/#placeholder-scanning", id);
    }
}