package com.xebialabs.deployit.service.validation;

import java.util.List;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;

import static com.google.common.collect.Lists.newArrayList;

@Component
public class Validator {

    public List<ValidationMessage> validate(ConfigurationItem roe, ConfigurationItem... cisInContext) {
        return validate(roe, newArrayList(cisInContext));
    }

    public List<ValidationMessage> validate(ConfigurationItem ci, List<ConfigurationItem> cisInContext) {
        return ci.getType().getDescriptor().validate(ci);
    }

    public void validateCi(ConfigurationItem item) throws ValidationsFailedException {
        List<ValidationMessage> messages = validate(item);
        if (!messages.isEmpty()) {
            ValidatedConfigurationItem validatedConfigurationItem = new ValidatedConfigurationItem(item);
            validatedConfigurationItem.setValidations(messages);
            throw new ValidationsFailedException(validatedConfigurationItem);
        }
    }

    public void validateCis(List<ConfigurationItem> entities) {
        List<ConfigurationItem> validated = newArrayList();
        boolean allValid = true;
        for (ConfigurationItem entity : entities) {
            List<ValidationMessage> messages = validate(entity);
            if (!messages.isEmpty()) {
                ValidatedConfigurationItem e = new ValidatedConfigurationItem(entity);
                e.setValidations(messages);
                validated.add(e);
            } else {
                validated.add(entity);
            }
            allValid = allValid && messages.isEmpty();
        }
        if (!allValid) {
            throw new ValidationsFailedException(validated);
        }
    }

    @SuppressWarnings("serial")
    @HttpResponseCodeResult(statusCode = 400)
    public static class ValidationsFailedException extends DeployitException {

        public ValidationsFailedException(List<ConfigurationItem> cis) {
            super(cis);
        }
        public ValidationsFailedException(ConfigurationItem ci) {
            super(ci);
        }

    }

}
