package com.xebialabs.deployit.service.version.exporter;

import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.springframework.stereotype.Component;

@Component
public class ManifestBasedManifestWriter implements ManifestWriter {
    static final String CI_NAME = "CI-Name";
    static final String CI_TYPE = "CI-Type";
    static final String CI_VERSION = "CI-Version";
    static final String CI_APPLICATION = "CI-Application";
    static final String DEPLOYIT_PACKAGE_FORMAT_VERSION = "Deployit-Package-Format-Version";
    
    private Manifest manifest;
    private Map<String, Attributes> entries;
    private String CI_PREFIX = "CI-";

    @Override
    public void addHeader(String application, String version) {
        manifest = new Manifest();
        entries = manifest.getEntries();
        final Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.putValue("Manifest-Version", "1.0");
        mainAttributes.putValue(DEPLOYIT_PACKAGE_FORMAT_VERSION, "1.3");
        mainAttributes.putValue(CI_APPLICATION, application);
        mainAttributes.putValue(CI_VERSION, version);
    }

    /* (non-Javadoc)
     * @see com.xebialabs.deployit.service.version.exporter.ManifestWriter#addResourceEntry(java.lang.String, java.lang.String, java.util.Map)
     */
    @Override
    public void addResourceEntry(String entryName, String type, Map<String, String> values) {
        Attributes attributesci = new Attributes();
        attributesci.putValue(CI_TYPE, type);
        for (Map.Entry<String, String> entry: values.entrySet()) {
            attributesci.putValue(CI_PREFIX + entry.getKey(), entry.getValue());
        }
        entries.put(entryName, attributesci);
    }

    /* (non-Javadoc)
     * @see com.xebialabs.deployit.service.version.exporter.ManifestWriter#addArtifactEntry(java.lang.String, java.lang.String, java.util.Map)
     */
    @Override
    public void addArtifactEntry(String entryName, String type, Map<String, String> values) {
        Attributes attributesci = new Attributes();
        attributesci.putValue(CI_TYPE, type);
        for (Map.Entry<String, String> entry: values.entrySet()) {
            attributesci.putValue(CI_PREFIX + entry.getKey(), entry.getValue());
        }
        entries.put(entryName, attributesci);
    }

    /* (non-Javadoc)
     * @see com.xebialabs.deployit.service.version.exporter.ManifestWriter#getManifest()
     */
    @Override
    public Manifest getManifest() {
        return this.manifest;
    }
}
