package com.xebialabs.deployit.task;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.repository.WorkDir;

import static com.google.common.collect.Lists.newArrayList;

@SuppressWarnings("serial")
public class WorkdirCleanerTrigger implements ExecutionStateListener {

    private List<WorkDir> workDirs = newArrayList();

    public WorkdirCleanerTrigger(WorkDir... workDir) {
        for (WorkDir dir : workDir) {
            workDirs.add(dir);
        }
    }

    @Override
    public void stepStateChanged(StepExecutionStateEvent event) {

    }

    @Override
    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (event.currentState().isFinal()) {
            logger.info("Cleaning Workdirs for task [{}]", event.task().getId());
            cleanWorkdirs();
        }
    }

    private void cleanWorkdirs() {
        for (WorkDir workDir : workDirs) {
            try {
                workDir.delete();
            } catch (RuntimeException re) {
                logger.error("Failed to clean WorkDir [{}]", workDir);
            }
        }
    }

    public List<WorkDir> getWorkDirs() {
        return workDirs;
    }

    private static final Logger logger = LoggerFactory.getLogger(WorkdirCleanerTrigger.class);
}
