package com.xebialabs.deployit.util;

import com.xebialabs.deployit.checks.Checks;

public class Either<T, U> {
    private T left;
    private U right;

    Either(T left, U right) {
        Checks.checkArgument((left == null || right == null) && right != left, "Either left or right should be given, not both");
        this.left = left;
        this.right = right;
    }

    public static <T, U> Either<T, U> either(T left, U right) {
        return new Either<T, U>(left, right);
    }

    public static <T, U> Either<T, U> left(T left) {
        return new Either<T, U>(left, null);
    }

    public static <T, U> Either<T, U> right(U right) {
        return new Either<T, U>(null, right);
    }

    public T getLeft() {
        return left;
    }

    public U getRight() {
        return right;
    }
}
