package com.xebialabs.deployit.util;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsSyncException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFiles {

    public static void umountQuietly(TFile file) {
        if (file == null) return;
        try {
            if (file.isArchive() && file.getEnclArchive() == null) {
                TFile.umount(file);
            }
        } catch (FsSyncException e) {
            logger.error("Could not umount {}, continuing", file);
            logger.debug("Exception was: ", e);
        }
    }

    public static boolean isArchive(String path) {
        TFile file = null;
        try {
            file = new TFile(path);
            return file.isArchive();
        } finally {
            umountQuietly(file);
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(TFiles.class);
}
