/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.Transitions;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.service.deployment.ChangeSetBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryUpdateTrigger
implements ExecutionStateListener {
    private DeltaSpecification specification;
    private static final Logger logger = LoggerFactory.getLogger(RepositoryUpdateTrigger.class);

    public RepositoryUpdateTrigger(DeltaSpecification specification) {
        this.specification = specification;
    }

    public void stepStateChanged(StepExecutionStateEvent event) {
    }

    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (Transitions.checkTransition((TaskExecutionStateEvent)event, (TaskExecutionState)TaskExecutionState.QUEUED, (TaskExecutionState)TaskExecutionState.EXECUTING)) {
            this.checkReferentialIntegrity(ChangeSetBuilder.determineChanges(this.specification));
        } else if (Transitions.checkTransition((TaskExecutionStateEvent)event, (TaskExecutionState)TaskExecutionState.EXECUTING, (TaskExecutionState)TaskExecutionState.EXECUTED)) {
            this.persist(ChangeSetBuilder.determineChanges(this.specification));
        }
    }

    private void persist(ChangeSet changeSet) {
        RepositoryServiceHolder.getRepositoryService().execute(changeSet);
    }

    private void checkReferentialIntegrity(ChangeSet changeSet) {
        RepositoryServiceHolder.getRepositoryService().checkReferentialIntegrity(changeSet);
    }
}

