/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.version.exporter;

import com.xebialabs.deployit.service.version.exporter.ManifestWriter;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.springframework.stereotype.Component;

@Component
public class ManifestBasedManifestWriter
implements ManifestWriter {
    static final String CI_NAME = "CI-Name";
    static final String CI_TYPE = "CI-Type";
    static final String CI_VERSION = "CI-Version";
    static final String CI_APPLICATION = "CI-Application";
    static final String DEPLOYIT_PACKAGE_FORMAT_VERSION = "Deployit-Package-Format-Version";
    private Manifest manifest;
    private Map<String, Attributes> entries;
    private String CI_PREFIX = "CI-";

    @Override
    public void addHeader(String application, String version) {
        this.manifest = new Manifest();
        this.entries = this.manifest.getEntries();
        Attributes mainAttributes = this.manifest.getMainAttributes();
        mainAttributes.putValue("Manifest-Version", "1.0");
        mainAttributes.putValue(DEPLOYIT_PACKAGE_FORMAT_VERSION, "1.3");
        mainAttributes.putValue(CI_APPLICATION, application);
        mainAttributes.putValue(CI_VERSION, version);
    }

    @Override
    public void addResourceEntry(String entryName, String type, Map<String, String> values) {
        Attributes attributesci = new Attributes();
        attributesci.putValue(CI_TYPE, type);
        for (Map.Entry<String, String> entry : values.entrySet()) {
            attributesci.putValue(this.CI_PREFIX + entry.getKey(), entry.getValue());
        }
        this.entries.put(entryName, attributesci);
    }

    @Override
    public void addArtifactEntry(String entryName, String type, Map<String, String> values) {
        Attributes attributesci = new Attributes();
        attributesci.putValue(CI_TYPE, type);
        for (Map.Entry<String, String> entry : values.entrySet()) {
            attributesci.putValue(this.CI_PREFIX + entry.getKey(), entry.getValue());
        }
        this.entries.put(entryName, attributesci);
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }
}

