/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.task.FilterType;
import com.xebialabs.deployit.task.TaskType;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ArchivedTaskSearchParameters {
    protected DateTime startDate;
    protected DateTime endDate;
    protected String executedBy;
    protected Set<Application> applications = Sets.newHashSet();
    protected Set<String> environments = Sets.newHashSet();
    protected String taskUuid;
    protected DateRange dateRangeSearch = DateRange.NONE;
    protected Status status = Status.ANY;
    protected EnumSet<TaskType> taskTypes = EnumSet.noneOf(TaskType.class);
    protected String orderBy;

    public ArchivedTaskSearchParameters() {
    }

    public ArchivedTaskSearchParameters(ArchivedTaskSearchParameters p) {
        this.startDate = p.startDate;
        this.endDate = p.endDate;
        this.executedBy = p.executedBy;
        this.applications = Sets.newHashSet(p.applications);
        this.environments = Sets.newHashSet(p.environments);
        this.dateRangeSearch = p.dateRangeSearch;
        this.status = p.status;
        this.taskUuid = p.taskUuid;
        this.taskTypes = p.taskTypes;
        this.orderBy = p.orderBy;
    }

    public ArchivedTaskSearchParameters orderBy(String property) {
        this.orderBy = property;
        return this;
    }

    public ArchivedTaskSearchParameters executedByUser(String user) {
        this.executedBy = user;
        return this;
    }

    public ArchivedTaskSearchParameters createdBetween(DateTime startDate, DateTime endDate) {
        Checks.checkNotNull(startDate, "Start date cannot be null");
        Checks.checkNotNull(endDate, "End date cannot be null");
        this.dateRangeSearch = DateRange.BETWEEN;
        if (startDate.isAfter((ReadableInstant)endDate)) {
            this.startDate = endDate;
            this.endDate = startDate;
        } else {
            this.startDate = startDate;
            this.endDate = endDate;
        }
        return this;
    }

    public ArchivedTaskSearchParameters createdOnOrBefore(DateTime endDate) {
        Checks.checkNotNull(endDate, "End date cannot be null");
        this.dateRangeSearch = DateRange.BEFORE;
        this.endDate = endDate;
        return this;
    }

    public ArchivedTaskSearchParameters createdOnOrAfter(DateTime startDate) {
        Checks.checkNotNull(startDate, "Start date cannot be null");
        this.dateRangeSearch = DateRange.AFTER;
        this.startDate = startDate;
        return this;
    }

    public ArchivedTaskSearchParameters forApplicationAndVersion(String application, String version) {
        Checks.checkTrue(this.environments.isEmpty(), "Can't query for both environments and applications.", new Object[0]);
        this.applications.add(new Application(application, version));
        return this;
    }

    public ArchivedTaskSearchParameters forApplication(String application) {
        return this.forApplicationAndVersion(application, null);
    }

    public ArchivedTaskSearchParameters thatAreOfType(EnumSet<TaskType> types) {
        this.taskTypes = types;
        return this;
    }

    public ArchivedTaskSearchParameters forEnvironment(String environment) {
        Checks.checkTrue(this.applications.isEmpty(), "Can't query for both environments and applications.", new Object[0]);
        this.environments.add(environment);
        return this;
    }

    public ArchivedTaskSearchParameters forFilterType(FilterType filterType, List<ConfigurationItemId> cis) {
        for (ConfigurationItemId appOrEnvName : cis) {
            this.forFilterType(filterType, appOrEnvName);
        }
        return this;
    }

    public ArchivedTaskSearchParameters forFilterType(FilterType filterType, ConfigurationItemId appOrEnvName) {
        switch (filterType) {
            case APPLICATION: {
                this.forApplication(appOrEnvName.getId());
                break;
            }
            case ENVIRONMENT: {
                this.forEnvironment(appOrEnvName.getId());
                break;
            }
        }
        return this;
    }

    public ArchivedTaskSearchParameters thatWasCancelled() {
        this.status = Status.CANCELLED;
        return this;
    }

    public ArchivedTaskSearchParameters thatCompleted() {
        this.status = Status.COMPLETED;
        return this;
    }

    public ArchivedTaskSearchParameters thatCompletedAfterRetry() {
        this.status = Status.COMPLETED_AFTER_RETRY;
        return this;
    }

    public ArchivedTaskSearchParameters withUniqueId(String uuid) {
        this.taskUuid = uuid;
        return this;
    }

    protected static class Application {
        public final String name;
        public final String version;

        Application(String name, String version) {
            this.name = name;
            this.version = version;
        }
    }

    public static enum Status {
        COMPLETED,
        CANCELLED,
        COMPLETED_AFTER_RETRY,
        ANY;

    }

    public static enum DateRange {
        AFTER,
        BEFORE,
        BETWEEN,
        NONE;

    }
}

