/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.xebialabs.deployit.exception.RuntimeIOException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileComparisonUtils {
    private static final IOFileFilter ALL_FILES_FILTER = TrueFileFilter.INSTANCE;
    private static final Logger LOG = LoggerFactory.getLogger(FileComparisonUtils.class);

    public static boolean contentEquals(File fileOrDir1, File fileOrDir2) throws IOException {
        if (!fileOrDir1.exists()) {
            throw new FileNotFoundException(fileOrDir1.getPath());
        }
        if (!fileOrDir2.exists()) {
            throw new FileNotFoundException(fileOrDir2.getPath());
        }
        if (fileOrDir1.isFile()) {
            if (fileOrDir2.isFile()) {
                return FileUtils.contentEquals((File)fileOrDir1, (File)fileOrDir2);
            }
            return false;
        }
        if (!fileOrDir2.isFile()) {
            return FileComparisonUtils.directoryContentEquals(fileOrDir1, fileOrDir2);
        }
        return false;
    }

    private static boolean directoryContentEquals(File dir1, File dir2) {
        return Arrays.equals(FileComparisonUtils.getDirectoryChecksum(dir1), FileComparisonUtils.getDirectoryChecksum(dir2));
    }

    private static byte[] getDirectoryChecksum(File dir) {
        long startTime = 0L;
        if (LOG.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            LOG.debug(String.format("Starting to calculate directory checksum for '%s'", dir, startTime));
        }
        MessageDigest digest = FileComparisonUtils.getMd5Digest();
        Iterator files = FileUtils.iterateFiles((File)dir, (IOFileFilter)ALL_FILES_FILTER, (IOFileFilter)ALL_FILES_FILTER);
        while (files.hasNext()) {
            File file = (File)files.next();
            try {
                FileComparisonUtils.updateChecksumFromContent(digest, file);
            }
            catch (IOException e) {
                throw new RuntimeIOException(String.format("Unable to update message digest for file '%s'", file), e);
            }
            digest.update(file.getName().getBytes());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Calculated directory checksum for '%s' in %dms", dir, System.currentTimeMillis() - startTime));
        }
        return digest.digest();
    }

    private static MessageDigest getMd5Digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to create MD5 digest", e);
        }
    }

    private static void updateChecksumFromContent(MessageDigest digest, File file) throws IOException {
        int numRead;
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            digest.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
    }
}

