package com.xebialabs.deployit.core.upgrade;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.jcr.JcrConstants;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.repository.core.Securable;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;

import static com.xebialabs.deployit.security.permission.DeployitPermissions.REPORT_VIEW;
import static com.xebialabs.deployit.security.permission.PlatformPermissions.LOGIN;

public class Deployit393ReportsView extends Upgrade {

    @Override
    public boolean doUpgrade(final RawRepository repository) throws UpgradeException {
        logger.info("*** Running Deployit 3.9.3 Upgrade: Reports view permissions ***");

        Node securityNode = repository.read(JcrConstants.SECURITY_NODE_ID);

        try {
            if(securityNode.hasProperty(Securable.SECURITY_PERMISSIONS_PROPERTY)) {
                Map<String, String> permissionToRoleIds = readGlobalPermissions(securityNode);
                String loginGrantedRoles = permissionToRoleIds.get(LOGIN.getPermissionName());
    
                logger.debug("Found global permissions: {}", permissionToRoleIds);
                logger.info("Granting " + REPORT_VIEW.getPermissionName() + " permission to all the roles that had login permission.");
    
                permissionToRoleIds.put(REPORT_VIEW.getPermissionName(), loginGrantedRoles);
                writeNewGlobalPermissions(securityNode, permissionToRoleIds);
            } else {
                logger.debug("Did not find global permissions.");
            }
            logger.info("*** Done Deployit 3.9.3 upgrade -- Reports view permissions ***");
            return true;
        } catch (RepositoryException e) {
            throw new UpgradeException("Could not convert global to local permissions", e);
        }
    }

    private Map<String, String> readGlobalPermissions(Node securityNode) throws RepositoryException {
        Property property = securityNode.getProperty(Securable.SECURITY_PERMISSIONS_PROPERTY);
        return JcrUtils.readMap(property);
    }

    private void writeNewGlobalPermissions(Node securityNode, Map<String, String> permissionToRoleIds) throws RepositoryException {
        JcrUtils.writeMap(securityNode, Securable.SECURITY_PERMISSIONS_PROPERTY, permissionToRoleIds);
    }

    @Override
    public Version upgradeVersion() {
        return Version.valueOf("deployit", "3.9.3");
    }

    private static final Logger logger = LoggerFactory.getLogger(Deployit393ReportsView.class);

}
