package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.xld.AppliedDistribution;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.Dictionaries;

import java.util.List;
import java.util.Optional;

public class DeploymentContext {

    private final AppliedDistribution appliedDistribution;
    private final Dictionaries dictionaries;
    private final BeanSupplier beanSupplier;
    private final DeployedTypeSupplier typeSupplier;
    private final ExistingDeployedSupplier existingDeployedSupplier;
    private final DeployedIdGenerator deployedIdGenerator;

    public DeploymentContext(AppliedDistribution appliedDistribution, Dictionaries dictionaries, BeanSupplier beanSupplier, DeployedTypeSupplier typeSupplier, ExistingDeployedSupplier existingDeployedSupplier) {
        this(appliedDistribution, dictionaries, beanSupplier, typeSupplier, existingDeployedSupplier, IdGenerator::generateId);
    }

    public DeploymentContext(AppliedDistribution appliedDistribution, Dictionaries dictionaries, BeanSupplier beanSupplier, DeployedTypeSupplier typeSupplier, ExistingDeployedSupplier existingDeployedSupplier, DeployedIdGenerator deployedIdGenerator) {
        this.appliedDistribution = appliedDistribution;
        this.dictionaries = dictionaries;
        this.beanSupplier = beanSupplier;
        this.typeSupplier = typeSupplier;
        this.existingDeployedSupplier = existingDeployedSupplier;
        this.deployedIdGenerator = deployedIdGenerator;
    }

    public DeployedTypeSupplier getTypeSupplier() {
        return typeSupplier;
    }

    public Dictionaries getDictionaries() {
        return dictionaries;
    }

    public ConsolidatedDictionary dictionaryFilteredByContainer(Container container) {
        return dictionaries.filterBy(container).consolidate();
    }

    public ExistingDeployedSupplier getExistingDeployedSupplier() {
        return existingDeployedSupplier;
    }

    public BeanSupplier getBeanSupplier() {
        return beanSupplier;
    }

    public AppliedDistribution getAppliedDistribution() {
        return appliedDistribution;
    }

    public DeployedIdGenerator getDeployedIdGenerator() {
        return deployedIdGenerator;
    }

    public DeploymentContext withIdGenerator(DeployedIdGenerator deployedIdGenerator) {
        return new DeploymentContext(appliedDistribution, dictionaries, beanSupplier, typeSupplier, existingDeployedSupplier, deployedIdGenerator);
    }

    public interface BeanSupplier {
        <T> T getBean(Class<T> beanClass);
    }

    public interface DeployedTypeSupplier {
        Type getType(Deployable deployable, Container container);
    }

    public interface ExistingDeployedSupplier {
        List<Deployed> getExistingDeployed(Deployable deployable);

        default Optional<Deployed> getExistingDeployedWithContainer(Deployable deployable, Container container) {
            List<Deployed> existingDeployeds = getExistingDeployed(deployable);
            return existingDeployeds == null ? Optional.empty() : existingDeployeds.stream().filter(d -> d.getContainer().equals(container)).findFirst();
        }
    }

    public interface DeployedIdGenerator {
        String generatedId(Container container, Deployable deployable);
    }

}

