package com.xebialabs.deployit.service.gc;

import java.util.concurrent.atomic.AtomicBoolean;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.execution.NonRemotableExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;

@SuppressWarnings("serial")
class GCSemaphore implements NonRemotableExecutionStateListener {

    private static final AtomicBoolean progress = new AtomicBoolean(false);

    public GCSemaphore() {
    }

    @Override
    public void stepStateChanged(StepExecutionStateEvent event) {
    }

    @Override
    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (event.currentState() == TaskExecutionState.STOPPED) {
            progress.set(false);
        } else if (event.currentState() == TaskExecutionState.EXECUTED) {
            progress.set(false);
        }
    }

    /**
     * Try to claim the process slot, will return true when the slot was claimed.
     * @return <code>true</code> if the slot could be claimed, <code>false</code> if the slot was already claimed.
     */
    public static boolean claimProcessSlot() {
        return progress.compareAndSet(false, true);
    }
}
