package com.xebialabs.deployit.task

import java.util

import com.xebialabs.deployit.engine.api.task.{TaskCreationService ⇒ ITaskCreationService}
import com.xebialabs.deployit.engine.tasker._
import com.xebialabs.deployit.plugin.api.flow.Step
import com.xebialabs.deployit.repository.WorkDirContext
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.security.core.Authentication
import org.springframework.stereotype.Component

import scala.collection.JavaConversions._

@Component
class TaskCreationService @Autowired() (val taskEngine: IEngine) extends ITaskCreationService {

  override def createWithStepBlock(owner: Authentication, description: String, steps: util.List[Step],
                                   metadata: util.Map[String, String]): String = {

    val taskSteps = steps.map(new TaskStep(_)).toList

    val spec = new TaskSpecification(
      description,
      owner,
      WorkDirContext.get(),
      BlockBuilders.steps(description, None, taskSteps).build(),
      null, false, true
    )
    spec.getMetadata.put(TaskMetadata.TASK_TYPE, TaskType.DEFAULT.name())
    val metadataOrEmpty: util.Map[String, String] = Option(metadata).getOrElse(Map[String, String]())
    spec.getMetadata.putAll(metadataOrEmpty)
    spec.getListeners.add(new WorkdirCleanerTrigger(WorkDirContext.get()))

    taskEngine.register(spec)
  }
}