package com.xebialabs.deployit.task;

import static com.google.common.base.Preconditions.checkState;

@SuppressWarnings("serial")
public class ThreadPoolTaskExecutor extends org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor {

    @Override
    public void initialize() {
        // Added checkState to prevent NPE 
        checkState(getCorePoolSize() < getMaxPoolSize(), "Cannot create task executor: max pool size [%s] should be larger than core pool size [%s]", getMaxPoolSize(), getCorePoolSize());
        super.initialize();
    }

}
