package com.xebialabs.deployit.task.archive

import javax.jcr.Node
import com.xebialabs.deployit.engine.api.execution.BlockState
import com.xebialabs.deployit.jcr.JcrUtils.getProperty
import NodeNames._
import com.xebialabs.deployit.task.archive.BlockType.COMPOSITE_BLOCK
import scala.collection.convert.wrapAll._
import scala.collection.mutable.ListBuffer

object CompositeBlockReader {

  def unapply(blockNode: Node): Option[BlockReader] = if (blockNode.hasProperty(BLOCK_TYPE) && getProperty(blockNode, BLOCK_TYPE).equals(COMPOSITE_BLOCK.name()))
    Some(new CompositeBlockReader)
  else None
}

class CompositeBlockReader extends BlockReader {

  override def read(blockNode: Node, loadSteps: Boolean, uptodateModel: Boolean): ArchivedAbstractBlock = {
    val block = new ArchivedCompositeBlock()

    readBasicBlockProperties(blockNode, block, uptodateModel)

    block.setParallel(getProperty(blockNode, IS_PARALLEL).toBoolean)

    val childBlocks = ListBuffer.empty[BlockState]
    val i = blockNode.getNodes
    while (i.hasNext) {
      val nextNode = i.nextNode()
      childBlocks += BlockReader(nextNode).read(nextNode, loadSteps, uptodateModel)
    }
    block.setBlocks(childBlocks)

    block
  }

  override def readFirstBlock(taskNode: Node, loadSteps: Boolean): ArchivedPhaseContainer = {
    val firstBlock = read(taskNode, loadSteps, BlockReader.DEPRECATED_MODEL)
    wrapInPhaseContainer(firstBlock)
  }
}