package com.xebialabs.deployit.task.archive

import javax.jcr.Node

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState
import com.xebialabs.deployit.jcr.JcrConstants._
import com.xebialabs.deployit.jcr.JcrUtils._
import com.xebialabs.deployit.task.TaskMetadata._

trait TaskReader {

  import com.xebialabs.deployit.task.archive.NodeNames._

  def taskNode: Node

  def readWithoutStep(): ArchivedTask

  def readWithStep(loadSteps: Boolean): ArchivedTask = {
    val task = readWithoutStep()
    if (task != null) {
      if (taskNode.hasNodes) {
        setBlockOrSteps(taskNode, task, loadSteps)
      }
    }
    task
  }

  protected def taskWithoutSteps: ArchivedTask = {
    if (!taskNode.isNodeType(TASK_NODETYPE_NAME)) {
      return null
    }

    val task = new ArchivedTask()

    task.setId(getProperty(taskNode, TASK_ID_PROPERTY_NAME))

    putMetadata(task, TASK_TYPE, getProperty(taskNode, DEPLOYMENT_TYPE))
    if (taskNode.hasProperty(TASK_NAME)) {
      putMetadata(task, TASK_NAME, getProperty(taskNode, TASK_NAME))
    }
    if (taskNode.hasProperty(TASK_DESCRIPTION)) {
      task.setDescription(getProperty(taskNode, TASK_DESCRIPTION))
    }
    if (taskNode.hasProperty(CONTROL_TASK_TARGET_CI)) {
      putMetadata(task, CONTROL_TASK_TARGET_CI, getProperty(taskNode, CONTROL_TASK_TARGET_CI))
    }

    task.setState(TaskExecutionState.valueOf(getProperty(taskNode, STATE)))
    task.setStartDate(getDate(taskNode, START_DATE))
    task.setCompletionDate(getDate(taskNode, COMPLETION_DATE))
    if (taskNode.hasProperty(SCHEDULED_DATE)) {
      task.setScheduledDate(getDate(taskNode, SCHEDULED_DATE))
    }
    task.setOwner(getOptionalProperty(taskNode, OWNING_USER))
    task.setFailureCount(getIntegerProperty(taskNode, FAILURE_COUNT))

    task
  }

  private def setBlockOrSteps(taskNode: Node, task: ArchivedTask, loadSteps: Boolean) {
    val firstNode = taskNode.getNodes.nextNode()

    val container = RootBlockReader(firstNode).readFirstBlock(firstNode, loadSteps)

    task.setBlock(container)
  }

}

object TaskReader {

  def apply(taskNode: Node): TaskReader = taskNode match {
    case CloudTask(cloudReader) => cloudReader
    case DeploymentTask(deploymentReader) => deploymentReader
    case _ => new DefaultTaskReader(taskNode)
  }

}