/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.deployment.ChangeSetBuilder;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecification;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.execution.NonRemotableExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.Transitions;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferentialIntegrityTrigger
implements NonRemotableExecutionStateListener {
    private MultiDeltaSpecification fullSpec;
    private static final Logger logger = LoggerFactory.getLogger(ReferentialIntegrityTrigger.class);

    public ReferentialIntegrityTrigger(MultiDeltaSpecification fullSpec) {
        this.fullSpec = fullSpec;
    }

    public void stepStateChanged(StepExecutionStateEvent event) {
    }

    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (Transitions.checkTransition((TaskExecutionStateEvent)event, (TaskExecutionState)TaskExecutionState.PENDING, (TaskExecutionState)TaskExecutionState.EXECUTING)) {
            this.checkReferentialIntegrity(ChangeSetBuilder.determineChanges((MultiDeltaSpecification)this.fullSpec));
        }
    }

    private void checkReferentialIntegrity(ChangeSet changeSet) {
        RepositoryServiceHolder.getRepositoryService().checkReferentialIntegrity(changeSet);
    }
}

