/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.gc;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.BlockBuilders;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.service.gc.GCSemaphore;
import com.xebialabs.deployit.service.gc.GarbageCollectionService;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import com.xebialabs.xlplatform.scheduler.step.DefaultGarbageCollectionStep;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="garbageCollectionService")
public class AsyncGarbageCollectionService
implements GarbageCollectionService {
    private static final Logger logger = LoggerFactory.getLogger(AsyncGarbageCollectionService.class);
    private final IEngine engine;
    private final GarbageCollectionService garbageCollectionService;
    private final WorkDirFactory workDirFactory;

    @Autowired
    public AsyncGarbageCollectionService(IEngine engine, GarbageCollectionService jackrabbitGarbageCollectionService, WorkDirFactory workDirFactory) {
        this.engine = engine;
        this.garbageCollectionService = jackrabbitGarbageCollectionService;
        this.workDirFactory = workDirFactory;
    }

    public void runGarbageCollector() {
        if (!GCSemaphore.claimProcessSlot()) {
            logger.warn("Not starting new garbage collector since garbage collection already in progress");
            return;
        }
        DefaultGarbageCollectionStep garbageCollectionStep = new DefaultGarbageCollectionStep(this.garbageCollectionService);
        String description = "Garbage collection";
        PhaseContainer stepBlock = BlockBuilders.steps((String)description, null, (List)Lists.newArrayList((Object[])new StepState[]{new TaskStep((Step)garbageCollectionStep)})).build();
        WorkDir workDir = this.workDirFactory.newWorkDir("gc");
        TaskSpecification spec = new TaskSpecification(description, Permissions.getAuthentication(), workDir, stepBlock, null, false, false, true);
        spec.getListeners().add(new GCSemaphore());
        spec.getListeners().add(new WorkdirCleanerTrigger(workDir));
        String id = this.engine.register(spec);
        this.engine.execute(id);
    }
}

